
package salesmansolver;

import com.google.maps.model.LatLng;

/**
 *
 * @author Andrea Barbagallo
 */
public class Gene {
    // A city
    private final String name;
    private final double x, y;
    
    public Gene(String name, double x, double y) {
        this.name = name;
        this.x = x;
        this.y = y;
    }
    
    public Gene(Gene g) {
        this.name = g.name;
        this.x = g.x;
        this.y = g.y;
    }
    
    public double getX() { return x; }
    public double getY() { return y; }
    
    public double distance(Gene other) {        
        return airlineDistance(new LatLng(this.x, this.y), new LatLng(other.x, other.y));
    }
    
    public double airlineDistance(LatLng departue, LatLng arrival) {
        departue.lat = Math.toRadians(departue.lat);
        departue.lng = Math.toRadians(departue.lng);
        arrival.lat = Math.toRadians(arrival.lat);
        arrival.lng = Math.toRadians(arrival.lng);
        
        double dlng = arrival.lng - departue.lng;
        double dlat = arrival.lat - departue.lat;
        double a = Math.pow(Math.sin(dlat / 2), 2) 
                 + Math.cos(departue.lat) * Math.cos(arrival.lat) 
                 * Math.pow(Math.sin(dlng / 2),2); 
              
        double c = 2 * Math.asin(Math.sqrt(a)); 
  
        // Radius of earth in kilometers. Use 3956 for miles
        double r = 6371; 
  
        // calculate the result 
        return(c * r); 
    }
    
    @Override
    public String toString() {
        return name;
    }
    
    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        
        Gene g = (Gene)o;
        return this.x == g.getX() && this.y == g.getY();
    }
}
